/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/
var XenCentral_AdServer_ResourceLoader = XenCentral_AdServer_ResourceLoader || {
        /**
         * 1st argument: string representation of object/property of object to be checked if ready
         * 2nd argument: function to be called when the 1st argument is available
         * 2nd argument: array of arguments to be given to first method when ready, if 2nd one is not function
         * 2nd, 3rd.. arguments: arguments to be given
         */
        callWhenReady: function () {
            var callback;
            var readyObjectName;
            var args = [];
            if (arguments.length == 0) {
                // nothing to call
                return;
            } else if (arguments.length == 1) {
                callback = arguments[0];
                readyObjectName = arguments[0];
                args = [];
            } else if (arguments.length == 2 && typeof Object.prototype.toString.call(arguments[1]) === '[object Array]') {
                callback = arguments[0];
                readyObjectName = arguments[0];
                args = arguments[1];
            } else if (arguments.length == 2 && typeof Object.prototype.toString.call(arguments[1]) === '[object Function]') {
                readyObjectName = arguments[0];
                callback = arguments[1];
                args = [];
            } else {
                readyObjectName = arguments[0];
                callback = arguments[0];
                for (var i = 1; i < arguments.length; i++) {
                    args[args.length] = arguments[i];
                }
            }

            var readyObject = this.getFunctionFromCallbackString(readyObjectName);
            if (readyObject) {
                if(Object.prototype.toString.call(callback)=='[object Function]') {
                    callback.apply(readyObject[0], args);
                } else {
                    readyObject[1].apply(readyObject[0], args);
                }
                return;
            }

            var tryCount = 0;
            var timeout = setInterval(function () {
                tryCount++;
                readyObject = XenCentral_AdServer_ResourceLoader.getFunctionFromCallbackString(readyObjectName);
                if (readyObject) {
                    clearInterval(timeout);
                    if (Object.prototype.toString.call(callback) == '[object Function]') {
                        callback.apply(readyObject[0], args);
                    } else {
                        readyObject[1].apply(readyObject[0], args);
                    }
                    return;
                }
                if (tryCount > 100) {
                    clearInterval(timeout);
                    console.log('Callback not found after 10 seconds: ' + callback);
                }
            }, 100);
        },
        getFunctionFromCallbackString: function (callback) {
            var parentObject = window;
            var currentObject = false;

            callback = callback.split(/\./);

            for (var i in callback) {
                if (!callback.hasOwnProperty(i)) {
                    continue;
                }

                if (currentObject === false) {
                    currentObject = parentObject[callback[i]];
                } else {
                    parentObject = currentObject;
                    currentObject = parentObject[callback[i]];
                }

                if (typeof currentObject == 'undefined') {
                    return false;
                }
            }

            return [parentObject, currentObject];
        },
        loadResources: function (resources) {
            if (typeof jQuery == "undefined") {
                var scriptElement = document.createElement('script');
                scriptElement.setAttribute("type", "text/javascript");
                scriptElement.setAttribute("src", resources.jQuerySource);
                scriptElement.async = false;
                document.getElementsByTagName("head")[0].appendChild(scriptElement);
            }

            for (var scriptId in resources.scripts) {
                if (!resources.scripts.hasOwnProperty(scriptId)) {
                    continue;
                }

                if (!document.getElementById(scriptId)) {
                    var scriptElement = document.createElement('script');
                    scriptElement.setAttribute("type", "text/javascript");
                    scriptElement.setAttribute("src", resources.scripts[scriptId]);
                    scriptElement.async = false;
                    document.getElementsByTagName("head")[0].appendChild(scriptElement);
                }
            }

            for (var linkId in resources.links) {
                if (!resources.links.hasOwnProperty(linkId)) {
                    continue;
                }

                if (!document.getElementById(linkId)) {
                    var linkElement = document.createElement("link");
                    linkElement.setAttribute("rel", "stylesheet");
                    linkElement.setAttribute("type", "text/css");
                    linkElement.setAttribute("id", linkId);
                    linkElement.setAttribute("href", resources.links[linkId]);
                    document.getElementsByTagName("head")[0].appendChild(linkElement);
                }
            }
        }
    };
